/***************************************************************/
//
//
//		DirectX	[Field.cpp]
//
//												Author	kazuki tanaka
//												Date	2016 05/30
/*---------------------------------------------------------------
Update : 2016/04/18
			bZ[W{bNX\
Update : 2016/04/25

/****************************************************************/


/****************************************************************/
//
//		wb_[t@C
//
/****************************************************************/
#include "main.h"
#include "Field.h"

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/

#define NUM_VERTEX (4)		// STRIP

#define NUM_FIELD (2)

/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/

// tB[hTCY̍\
typedef struct{

	D3DXVECTOR3 start;
	unsigned int height;
	unsigned int width;
	float size;

}FIELD_SIZE;

/*---------------------------------------------------------------
	vg^Cv錾
---------------------------------------------------------------*/

void MakeVertexField(LPDIRECT3DDEVICE9 pDevice);		// _̍쐬

/*----------------------------------------------------------------
	O[oϐ
----------------------------------------------------------------*/
//static VERTEX_3D g_aVertex[NUM_VERTEX];				// _

LPDIRECT3DTEXTURE9 g_pTextureField=nullptr;				// eNX`-C^[tF-Xp

LPDIRECT3DVERTEXBUFFER9 g_pVtxBufferField = nullptr;	// _obt@C^[tF[Xւ̃|C^
LPDIRECT3DINDEXBUFFER9 g_pIdxBufferField  = nullptr;	// CfbNXobt@C^[tF[Xւ̃|C^

FIELD_SIZE g_field;

static char* TEXTURE_NAME[ ] = {
	"data\\TEXTURE\\wall000.jpg",
};


// |S̏
void InitField( void )
{

	
	g_field.height = 3;
	g_field.width  = 3;
	g_field.size   = 10;
	g_field.start  = D3DXVECTOR3( -15, 0, 15 );  
	

	// foCX󂯎p֐
	LPDIRECT3DDEVICE9 g_pPD3DDevice = GetDevice( );

	//MakeVertexField(g_pPD3DDevice);

	// eNX`̓ǂݍ 
	if( FAILED( D3DXCreateTextureFromFile( g_pPD3DDevice, TEXTURE_NAME[0], &g_pTextureField )))
	{
		#ifdef _DEBUG
		MessageBox( NULL, "FIELDeNX`t@C̓ǂݍ݂Ɏs܂!" , "TEXTURE LOAD ERROR!!", MB_OK | MB_ICONWARNING );
		#endif	// _DEBUG
	}

	
}

// |S̏
void UninitField( void )
{

	SAFE_RELEASE(g_pTextureField)

	SAFE_RELEASE( g_pVtxBufferField )

	SAFE_RELEASE( g_pIdxBufferField )

}

// |S̍XV
void UpdateField( void )
{

}

// |S̕`
void DrawField( void )
{


	// foCX̎󂯎
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	D3DXMATRIX mtxDefault;

	// Pʍsւ̏( sPʍsɂ )
	D3DXMatrixIdentity( &mtxDefault );

	// foCXɃ[hϊsݒ
	pDevice ->SetTransform( D3DTS_WORLD, &mtxDefault );

	// Xg[
	pDevice ->SetStreamSource( 0,
	g_pVtxBufferField,								// Xg[ɃoCh钸_obt@
	0,												// Xg[擪璸_f[^擪܂ł̃ItZbg (oCgP)
	sizeof( VERTEX_3D ));							// ̃XgChl(oCgP)

	// _tH[}bg̐ݒ
	pDevice->SetFVF( FVF_VERTEX_3D );

	// CfbNXobt@̐ݒ
	pDevice ->SetIndices( g_pIdxBufferField );

	// eNX`̐ݒ
	pDevice->SetTexture( 0, g_pTextureField );

	/*
	D3DMATERIAL9 mat;
	
	ZeroMemory( &mat, sizeof( mat ));

	mat.Ambient.r = 1.0f;
	mat.Ambient.g = 0.0f;
	mat.Ambient.b = 0.0f;
	mat.Ambient.a = 1.0f;

	pDevice ->SetMaterial( &mat );
	*/

	// |S̕`
	pDevice ->DrawIndexedPrimitive( D3DPT_TRIANGLESTRIP, 0, 0, ((2 + 2 * g_field.width)*g_field.height + ( g_field.height - 1 )*2), 0, ((2 + 2 * g_field.width)*g_field.height + ( g_field.height - 1 )*2)-2 );

}

// _̍쐬
void MakeVertexField(LPDIRECT3DDEVICE9 pDevice)
{


	VERTEX_3D *pVtx;											// zAhX
	WORD      *pIndex;											// zAhXCfbNX

	// _obt@̍쐬
	if( FAILED( pDevice ->CreateVertexBuffer(
			sizeof( VERTEX_3D ) * (( g_field.width + 1 )  * ( g_field.height + 1 )),			// mۂobt@TCY(_m) P:oCg
			D3DUSAGE_WRITEONLY,									// gp@
			FVF_VERTEX_3D,										// gp钸_tH[}bg
			D3DPOOL_MANAGED,									// obt@̊Ǘ@
			&g_pVtxBufferField,									// i[|C^
			NULL )))
	{
		#ifdef _DEBUG
		MessageBox( NULL, "obt@ւ݂̏Ɏs܂!!" , " FIELD VTXBUF ERROR !!" , MB_OK );
		#endif	// _DEBUG

		return;
	}


	// zAhX̎擾
	g_pVtxBufferField -> Lock( 0, 0, (void**)&pVtx, 0 );

	int index = 0;

	// _obt@̐ݒ

	// CREATE MESH FIELD
	for( int y = 0,x = 0; y < g_field.height+1; y++ ){

		for( x = 0; x < g_field.width+1; x++ ){
		
			pVtx[ ((g_field.width+1))*y + (x) + 0 ].pos    = D3DXVECTOR3 ( g_field.start.x + ( g_field.size * x ), 0, g_field.start.z - ( g_field.size * y) );

			pVtx[ ((g_field.width+1))*y + (x) + 0 ].tex    = D3DXVECTOR2( (1.0f * x), (1.0f * y) );

			pVtx[ ((g_field.width+1))*y + (x) + 0 ].color  = D3DCOLOR_RGBA(255,255,255,255);

			pVtx[ ((g_field.width+1))*y + (x) + 0 ].normal = D3DXVECTOR3( 0.0f, 1.0f, 0.0f );
		}
	}

	// obt@̃AbN
	g_pVtxBufferField ->Unlock( );


	// CfbNXobt@̒`
	if( FAILED( pDevice ->CreateIndexBuffer(
		sizeof( WORD ) * ((2 + 2 * g_field.width)*g_field.height + ( g_field.height - 1 )*2),
		D3DUSAGE_WRITEONLY,
		D3DFMT_INDEX16,
		D3DPOOL_MANAGED,
		&g_pIdxBufferField,
		NULL)))
	{
		#ifdef _DEBUG
		MessageBox( NULL, "Indexւ݂̏Ɏs܂!!", "Index Buffer ERROR !!", MB_OK | MB_ICONWARNING );
		#endif	// -> _DEBUG
		return;
	}

	// CfbNXbNzAhX擾
	g_pIdxBufferField->Lock( 0, 0, (void**)&pIndex, 0 );

	int whiteBox;

	// _W̐ݒ
	for( int y = 0,x = 0,alignNumber = 0,index = 0; y < g_field.height; y++ ){

		// kރ|S̍쐬
		if( y ){
			
			x = 0;
			pIndex[ ((g_field.width+1)*2)*y + (2*x) + 0 + alignNumber*2 ] = index - 1;
			pIndex[ ((g_field.width+1)*2)*y + (2*x) + 1 + alignNumber*2 ] = index + (g_field.width+1);
			alignNumber++;
		}

		for( x = 0; x < g_field.width+1; x++ ){

			pIndex[ ((g_field.width+1)*2)*y + (2*x) + 0 + alignNumber*2 ] = index + (g_field.width+1);
			pIndex[ ((g_field.width+1)*2)*y + (2*x) + 1 + alignNumber*2 ] = index;
			index++;
		}
	}

	/*
	#ifdef _DEBUG
	char str[4096];
	for( int index = 0 ; index < ((2 + 2 * g_field.width)*g_field.height + ( g_field.height - 1 )*2); index++ ){
		sprintf( str, "%d : %d", index,pIndex[ index ] );
		MessageBox( NULL, str, "INDEX", MB_OK );
	}
	#endif	// _DEBUG
	*/

	// obt@̃AbN
	g_pIdxBufferField ->Unlock( );



	return;

}

// MESHFIELD̍쐬
void CreateMeshField( const D3DXVECTOR3 coord, const float length, const unsigned int fieldNumber )
{


	// tB[h
	SAFE_RELEASE( g_pVtxBufferField )
	SAFE_RELEASE( g_pIdxBufferField )

	// tB[hݒ菈
	g_field.height = fieldNumber;
	g_field.width  = fieldNumber;
	g_field.size   = length;
	g_field.start  = coord;  

	{ // tB[h

		// foCX󂯎p֐
		LPDIRECT3DDEVICE9 pDevice = GetDevice( );

		MakeVertexField( pDevice );

	} // -> END FIELD SET


}

// MESHFIELD̍쐬
void CreateMeshFieldCenter( const float length, const unsigned int fieldNumber )
{


	// tB[h
	SAFE_RELEASE( g_pVtxBufferField )
	SAFE_RELEASE( g_pIdxBufferField )

	// SZo
	float harfdiamiter =  (float)((float)fieldNumber * 0.5f) * length;

	// tB[hݒ菈
	g_field.height = fieldNumber;
	g_field.width  = fieldNumber;
	g_field.size   = length;
	g_field.start  = D3DXVECTOR3( -harfdiamiter, 0, harfdiamiter );  

	{ // tB[h

		// foCX󂯎p֐
		LPDIRECT3DDEVICE9 g_pPD3DDevice = GetDevice( );

		MakeVertexField(g_pPD3DDevice);

	}	// -> END FIELD SET

}

// MESHFIELD̍쐬
void CreateMeshFieldCenter( const int width, const int height, const float length )
{


	// tB[h
	SAFE_RELEASE( g_pVtxBufferField )
	SAFE_RELEASE( g_pIdxBufferField )

	// SZo
	float harfdiamiterX =  (float)((float)width * 0.5f) * length;
	float harfdiamiterZ =  (float)((float)height * 0.5f) * length;

	// tB[hݒ菈
	g_field.height = height;
	g_field.width  = width;
	g_field.size   = length;
	g_field.start  = D3DXVECTOR3( -harfdiamiterX, 0, harfdiamiterZ );  

	{ // tB[h

		// foCX󂯎p֐
		LPDIRECT3DDEVICE9 g_pPD3DDevice = GetDevice( );

		MakeVertexField(g_pPD3DDevice);

	}	// -> END FIELD SET

}


